-- Create the vintage weight multiplied version of the annual results (to be summed later), 
--  If the total ERA weight is 0, then don't multiply by wt_vint, set the wt to 1.0; 
--     the sum process in the next step will then use the average of the vintage impact values for era
--  Also, decide here which peak demand value is used in subsequent tables (2 - 5, or 4 - 9)
DROP TABLE IF EXISTS meas_impacts_tmp;

CREATE TABLE meas_impacts_tmp (
  EnergyImpactID TEXT NOT NULL,
  Version TEXT,
  VersionSource TEXT,
  LastMod TEXT,
  PA TEXT NOT NULL,
  BldgType TEXT NOT NULL,
  BldgVint TEXT NOT NULL,
  era TEXT,
  BldgLoc TEXT NOT NULL,
  BldgHVAC TEXT NOT NULL,
  wt_vint NUMERIC,
  NormUnit TEXT,
  NumUnit REAL,
  MeasArea NUMERIC,
  ScaleBasis TEXT,
--PreWBkWh REAL,
--PreWBkW25 REAL,
--PreWBkW49 REAL,
--PreWBthm REAL,
--StdWBkWh REAL,
--StdWBkW25 REAL,
--StdWBkW49 REAL,
--StdWBthm REAL,
--MsrWBkWh REAL,
--MsrWBkW25 REAL,
--MsrWBkW49 REAL,
--MsrWBthm REAL,
  APreWBkWh REAL,
  APreWBkW REAL,
  APreWBtherm REAL,
  AStdWBkWh REAL,
  AStdWBkW REAL,
  AStdWBtherm REAL,
  "Note1" TEXT,
  PRIMARY KEY ("EnergyImpactID", "PA", "BldgType", "BldgVint", "BldgLoc", "BldgHVAC")
);


INSERT INTO meas_impacts_tmp
SELECT
"EnergyImpactID",
"Version",
"VersionSource",
"LastMod",
wts_res_vintage.pa as "PA",
meas_impacts."BldgType",
meas_impacts."BldgVint",
wts_res_vintage.era as "era",
meas_impacts."BldgLoc",
meas_impacts."BldgHVAC",
CASE WHEN wts_res_loc.sum_loc = 0 THEN 1 ELSE wts_res_vintage.wt_vint END as "wt_vint",
"NormUnit",
"NumUnit" * wt_vint as "NumUnit",
"MeasArea" * wt_vint as "MeasArea",
'None' as "ScaleBasis",
CASE WHEN wts_res_loc.sum_loc = 0 THEN "APreWBkWh"   ELSE "APreWBkWh" * wt_vint   END as "APreWBkWh",
CASE WHEN wts_res_loc.sum_loc = 0 THEN "APreWBkW49"  ELSE "APreWBkW49" * wt_vint  END as "APreWBkW",
CASE WHEN wts_res_loc.sum_loc = 0 THEN "APreWBtherm" ELSE "APreWBtherm" * wt_vint END as "APreWBtherm",
CASE WHEN wts_res_loc.sum_loc = 0 THEN "AStdWBkWh"   ELSE "AStdWBkWh" * wt_vint   END as "AStdWBkWh",
CASE WHEN wts_res_loc.sum_loc = 0 THEN "AStdWBkW49"  ELSE "AStdWBkW49" * wt_vint  END as "AStdWBkW",
CASE WHEN wts_res_loc.sum_loc = 0 THEN "AStdWBtherm" ELSE "AStdWBtherm" * wt_vint END as "AStdWBtherm",
"Note1"
from meas_impacts
JOIN wts_res_vintage on 
 wts_res_vintage.bldgtype = meas_impacts."BldgType" and 
 wts_res_vintage.bldgvint = meas_impacts."BldgVint" and 
 wts_res_vintage.bldgloc  = meas_impacts."BldgLoc"
JOIN wts_res_loc on 
 wts_res_vintage.pa       = wts_res_loc.pa and 
 wts_res_vintage.bldgtype = wts_res_loc.bldgtype and 
 wts_res_vintage.bldgloc  = wts_res_loc.bldgloc and
 wts_res_vintage.era      = wts_res_loc.era
ORDER BY 
"EnergyImpactID",
wts_res_vintage.pa,
meas_impacts."BldgType",
meas_impacts."BldgVint",
meas_impacts."BldgLoc",
meas_impacts."BldgHVAC";

--ALTER TABLE "meas_impacts_tmp"
--ALTER COLUMN "EnergyImpactID" SET NOT NULL,
--ALTER COLUMN "PA" SET NOT NULL,
--ALTER COLUMN "BldgType" SET NOT NULL,
--ALTER COLUMN "BldgVint" SET NOT NULL,
--ALTER COLUMN "BldgLoc" SET NOT NULL,
--ALTER COLUMN "BldgHVAC" SET NOT NULL,
--ADD PRIMARY KEY ("EnergyImpactID", "PA", "BldgType", "BldgVint", "BldgLoc", "BldgHVAC");
